# GrowDiary – WordPress Plugin

A **20-week growing diary** plugin for plant and garden growers.  
Inspired by GrowDiaries.com — full CRUD frontend, no page reloads.

---

## Features

- 📔 **Unlimited grow diaries** per user  
- 📅 **20 weekly log entries** per diary  
- 🌿 Track: stage, height, temp, humidity, VPD, pH, EC/PPM, watering, nutrients  
- 📸 **Photo galleries** per week using WP Media Uploader  
- ⭐ Weekly **star ratings**  
- 🌍 **Public / Private** visibility  
- 🏡 **Community page** – browse all public grows  
- 🔒 Uses **WP native registration & login**  
- ⚡ Full **AJAX CRUD** – no page reloads  

---

## Installation

1. Upload the `growdiary/` folder to `/wp-content/plugins/`
2. Activate via **Plugins → Installed Plugins**
3. The plugin auto-creates 4 pages on activation:
   - `/my-grows/` – dashboard (requires login)
   - `/new-grow/` – redirects to dashboard modal
   - `/view-grow/` – single diary view (`?diary_id=123`)
   - `/community-grows/` – public diary browser

---

## File Structure

```
growdiary/
├── growdiary.php              # Main plugin file
├── includes/
│   ├── db.php                 # Custom DB table creation
│   ├── post-types.php         # Page auto-creation on activation
│   ├── shortcodes.php         # [shortcode] definitions
│   └── ajax.php               # All AJAX handlers (CRUD)
├── templates/
│   ├── dashboard.php          # My Grows page HTML
│   ├── view-diary.php         # Single diary view HTML
│   └── community.php          # Community page HTML
└── assets/
    ├── css/growdiary.css      # Full UI stylesheet
    └── js/growdiary.js        # All frontend JS / AJAX
```

---

## Database Tables

### `wp_growdiary_diaries`
| Column | Type | Description |
|--------|------|-------------|
| id | BIGINT | Primary key |
| user_id | BIGINT | WP user |
| title | VARCHAR | Diary name |
| strain | VARCHAR | Plant strain |
| grow_medium | VARCHAR | Soil, Hydro, Coco… |
| light_type | VARCHAR | LED, HPS, CMH… |
| light_watts | SMALLINT | Wattage |
| grow_space | VARCHAR | Tent/room size |
| nutrients | TEXT | Feeding line |
| start_date | DATE | Grow start |
| cover_image | VARCHAR | Image URL |
| visibility | ENUM | public/private |
| status | ENUM | active/harvested/failed |
| notes | TEXT | Setup notes |

### `wp_growdiary_weeks`
| Column | Type | Description |
|--------|------|-------------|
| diary_id | BIGINT | Parent diary |
| week_number | TINYINT | 1–20 |
| stage | ENUM | germination → harvest |
| height_cm | DECIMAL | Plant height |
| ph_water | DECIMAL | pH going in |
| ph_runoff | DECIMAL | pH runoff |
| ec_ppm | SMALLINT | EC / PPM |
| temp_c | DECIMAL | Temperature |
| humidity_pct | TINYINT | Relative humidity |
| vpd | DECIMAL | Vapour Pressure Deficit |
| light_hours | TINYINT | Daily photoperiod |
| watering_ml | SMALLINT | Volume fed |
| nutrients | TEXT | Nutrient schedule |
| observations | TEXT | Growth notes |
| problems | TEXT | Issues / pests |
| images | TEXT | JSON array of URLs |
| rating | TINYINT | 1–5 stars |

---

## AJAX Actions

| Action | Auth | Description |
|--------|------|-------------|
| `growdiary_create_diary` | ✅ | Create new diary |
| `growdiary_get_diaries` | ✅ | List user's diaries |
| `growdiary_get_diary` | 👁️ | Single diary + weeks |
| `growdiary_update_diary` | ✅ | Edit diary meta |
| `growdiary_delete_diary` | ✅ | Delete diary + weeks |
| `growdiary_save_week` | ✅ | Upsert weekly entry |
| `growdiary_delete_week` | ✅ | Delete weekly entry |
| `growdiary_get_public` | 👁️ | Paginated public diaries |

---

## Extending

- **Add a comments system**: Use WP native comments tied to diary_id stored in a custom meta field
- **Follow system**: Add a `wp_growdiary_follows` table
- **Notifications**: Hook into `save_week` to email followers
- **Harvest report**: Add a dedicated harvest modal with yield, smell, taste ratings
- **Import/Export**: Add CSV export of weekly stats

---

## Requirements

- WordPress 6.0+
- PHP 7.4+
- jQuery (bundled with WP)
