<?php
/**
 * Plugin Name: GrowDiary
 * Plugin URI:  https://yoursite.com/growdiary
 * Description: A 20-week growing diary for plant and garden growers. Create, track, and share your grows.
 * Version:     1.0.0
 * Author:      Your Name
 * License:     GPL2
 * Text Domain: growdiary
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'GROWDIARY_VERSION', '1.0.0' );
define( 'GROWDIARY_DIR',     plugin_dir_path( __FILE__ ) );
define( 'GROWDIARY_URL',     plugin_dir_url( __FILE__ ) );

/* -----------------------------------------------------------------------
   Load sub-modules
----------------------------------------------------------------------- */
require_once GROWDIARY_DIR . 'includes/db.php';
require_once GROWDIARY_DIR . 'includes/post-types.php';
require_once GROWDIARY_DIR . 'includes/shortcodes.php';
require_once GROWDIARY_DIR . 'includes/ajax.php';

/* -----------------------------------------------------------------------
   Activation / Deactivation
----------------------------------------------------------------------- */
register_activation_hook( __FILE__, 'growdiary_activate' );
function growdiary_activate() {
    growdiary_create_tables();
    growdiary_register_post_types();
    flush_rewrite_rules();
}

register_deactivation_hook( __FILE__, 'growdiary_deactivate' );
function growdiary_deactivate() {
    flush_rewrite_rules();
}

/* -----------------------------------------------------------------------
   Enqueue assets (frontend only)
----------------------------------------------------------------------- */
add_action( 'wp_enqueue_scripts', 'growdiary_enqueue_assets' );
function growdiary_enqueue_assets() {
    wp_enqueue_style(
        'growdiary-style',
        GROWDIARY_URL . 'assets/css/growdiary.css',
        [],
        GROWDIARY_VERSION
    );

    wp_enqueue_media(); // for image uploader

    wp_enqueue_script(
        'growdiary-app',
        GROWDIARY_URL . 'assets/js/growdiary.js',
        [ 'jquery' ],
        GROWDIARY_VERSION,
        true
    );

    $view_page = get_page_by_path( 'view-grow' );
    wp_localize_script( 'growdiary-app', 'GrowDiary', [
        'ajax_url' => admin_url( 'admin-ajax.php' ),
        'nonce'    => wp_create_nonce( 'growdiary_nonce' ),
        'user_id'  => get_current_user_id(),
        'logged_in'=> is_user_logged_in() ? 'yes' : 'no',
        'view_url' => $view_page ? get_permalink( $view_page->ID ) : home_url( '/view-grow/' ),
    ] );
}
