<?php
/**
 * GrowDiary – Post Types & Rewrite Rules
 * We use custom DB tables for data, but register a CPT to handle
 * pretty permalink pages like /my-grows/ and /grow/123/
 */

if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'init', 'growdiary_register_post_types' );
function growdiary_register_post_types() {
    // Not used for storage – just for routing if needed
    // All data lives in custom DB tables via AJAX
}

/* -----------------------------------------------------------------------
   Register plugin pages on activation via options
----------------------------------------------------------------------- */
add_action( 'init', 'growdiary_maybe_create_pages' );
function growdiary_maybe_create_pages() {
    if ( get_option( 'growdiary_pages_created' ) ) return;

    $pages = [
        [
            'title'     => 'My Grows',
            'slug'      => 'my-grows',
            'content'   => '[growdiary_dashboard]',
        ],
        [
            'title'     => 'Start a Grow',
            'slug'      => 'new-grow',
            'content'   => '[growdiary_new_diary]',
        ],
        [
            'title'     => 'View Grow',
            'slug'      => 'view-grow',
            'content'   => '[growdiary_view_diary]',
        ],
        [
            'title'     => 'Community Grows',
            'slug'      => 'community-grows',
            'content'   => '[growdiary_community]',
        ],
    ];

    foreach ( $pages as $page ) {
        $exists = get_page_by_path( $page['slug'] );
        if ( ! $exists ) {
            wp_insert_post( [
                'post_title'   => $page['title'],
                'post_name'    => $page['slug'],
                'post_content' => $page['content'],
                'post_status'  => 'publish',
                'post_type'    => 'page',
            ] );
        }
    }

    update_option( 'growdiary_pages_created', true );
}
