<?php
/**
 * GrowDiary – Shortcodes
 * All frontend HTML is rendered here; JS takes over from there.
 */

if ( ! defined( 'ABSPATH' ) ) exit;

/* -----------------------------------------------------------------------
   [growdiary_dashboard] – user's diary list
----------------------------------------------------------------------- */
add_shortcode( 'growdiary_dashboard', function() {
    if ( ! is_user_logged_in() ) {
        return '<div class="gd-notice">' . wp_login_form( [ 'echo' => false ] ) . '</div>';
    }
    ob_start();
    include GROWDIARY_DIR . 'templates/dashboard.php';
    return ob_get_clean();
} );

/* -----------------------------------------------------------------------
   [growdiary_view_diary] – single diary view (works for owner + public)
----------------------------------------------------------------------- */
add_shortcode( 'growdiary_view_diary', function() {
    ob_start();
    include GROWDIARY_DIR . 'templates/view-diary.php';
    return ob_get_clean();
} );

/* -----------------------------------------------------------------------
   [growdiary_community] – browseable public diaries
----------------------------------------------------------------------- */
add_shortcode( 'growdiary_community', function() {
    ob_start();
    include GROWDIARY_DIR . 'templates/community.php';
    return ob_get_clean();
} );
