<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<div id="gd-app">

  <!-- ===== Header ===== -->
  <div class="gd-header">
    <h1 class="gd-title">🌿 My Grows</h1>
    <button class="gd-btn gd-btn-primary" id="gd-open-create">+ Start New Grow</button>
  </div>

  <!-- ===== Diary grid ===== -->
  <div id="gd-diary-grid" class="gd-diary-grid">
    <div class="gd-loading">Loading your diaries…</div>
  </div>

  <!-- ===================================================
       MODAL: Create / Edit Diary
  =================================================== -->
  <div id="gd-modal-diary" class="gd-modal" style="display:none">
    <div class="gd-modal-overlay"></div>
    <div class="gd-modal-box">
      <div class="gd-modal-header">
        <h2 id="gd-modal-diary-title">Start a New Grow</h2>
        <button class="gd-modal-close" data-close="gd-modal-diary">&times;</button>
      </div>
      <div class="gd-modal-body">
        <form id="gd-form-diary" class="gd-form">

          <div class="gd-form-row gd-form-row--2">
            <div class="gd-field">
              <label>Diary Title *</label>
              <input type="text" name="title" placeholder="e.g. Summer 2025 Tent Grow" required>
            </div>
            <div class="gd-field">
              <label>Strain Name</label>
              <input type="text" name="strain" placeholder="e.g. Wedding Cake Auto">
            </div>
          </div>

          <div class="gd-form-row gd-form-row--3">
            <div class="gd-field">
              <label>Grow Medium</label>
              <select name="grow_medium">
                <option value="">– Select –</option>
                <option>Soil</option>
                <option>Coco Coir</option>
                <option>Hydroponics</option>
                <option>Aeroponics</option>
                <option>Aquaponics</option>
                <option>Perlite</option>
                <option>Rockwool</option>
                <option>RDWC</option>
              </select>
            </div>
            <div class="gd-field">
              <label>Light Type</label>
              <select name="light_type">
                <option value="">– Select –</option>
                <option>HPS</option>
                <option>CMH / LEC</option>
                <option>LED (Full Spectrum)</option>
                <option>CFL</option>
                <option>T5 / T8</option>
                <option>MH</option>
                <option>Sunlight</option>
              </select>
            </div>
            <div class="gd-field">
              <label>Light Watts</label>
              <input type="number" name="light_watts" placeholder="e.g. 600" min="0">
            </div>
          </div>

          <div class="gd-form-row gd-form-row--2">
            <div class="gd-field">
              <label>Grow Space (e.g. 1.2×1.2m tent)</label>
              <input type="text" name="grow_space" placeholder="e.g. 4×4 ft tent">
            </div>
            <div class="gd-field">
              <label>Start Date</label>
              <input type="date" name="start_date">
            </div>
          </div>

          <div class="gd-field">
            <label>Nutrients / Feeding Line</label>
            <input type="text" name="nutrients" placeholder="e.g. GHE Flora Series, BioBizz">
          </div>

          <div class="gd-field">
            <label>Cover Image URL</label>
            <div class="gd-image-upload-row">
              <input type="text" name="cover_image" id="gd-cover-image-url" placeholder="Paste URL or use upload button">
              <button type="button" class="gd-btn gd-btn-sm" id="gd-cover-upload-btn">Upload</button>
            </div>
            <div id="gd-cover-preview" class="gd-img-preview" style="display:none">
              <img src="" alt="Cover preview" id="gd-cover-img">
            </div>
          </div>

          <div class="gd-form-row gd-form-row--2">
            <div class="gd-field">
              <label>Visibility</label>
              <select name="visibility">
                <option value="private">🔒 Private</option>
                <option value="public">🌍 Public</option>
              </select>
            </div>
            <div class="gd-field" id="gd-status-field" style="display:none">
              <label>Status</label>
              <select name="status">
                <option value="active">🟢 Active</option>
                <option value="harvested">🌾 Harvested</option>
                <option value="failed">💀 Failed</option>
              </select>
            </div>
          </div>

          <div class="gd-field">
            <label>Grow Notes / Setup Description</label>
            <textarea name="notes" rows="4" placeholder="Describe your setup, goals, expectations…"></textarea>
          </div>

          <div class="gd-form-actions">
            <button type="submit" class="gd-btn gd-btn-primary">Save Diary</button>
            <button type="button" class="gd-btn gd-btn-ghost" data-close="gd-modal-diary">Cancel</button>
          </div>

          <div class="gd-form-msg" id="gd-diary-msg"></div>
        </form>
      </div>
    </div>
  </div>

  <!-- ===================================================
       MODAL: View / Edit Weekly Entries
  =================================================== -->
  <div id="gd-modal-weeks" class="gd-modal" style="display:none">
    <div class="gd-modal-overlay"></div>
    <div class="gd-modal-box gd-modal-box--wide">
      <div class="gd-modal-header">
        <h2 id="gd-weeks-title">Weekly Log</h2>
        <button class="gd-modal-close" data-close="gd-modal-weeks">&times;</button>
      </div>
      <div class="gd-modal-body">

        <!-- Week selector tabs -->
        <div class="gd-week-tabs" id="gd-week-tabs"></div>

        <!-- Week form -->
        <form id="gd-form-week" class="gd-form">
          <input type="hidden" name="diary_id" id="gd-week-diary-id">
          <input type="hidden" name="week_number" id="gd-week-number">

          <div class="gd-form-row gd-form-row--2">
            <div class="gd-field">
              <label>Growth Stage</label>
              <select name="stage">
                <option value="germination">🌱 Germination</option>
                <option value="seedling">🌿 Seedling</option>
                <option value="vegetative">🍃 Vegetative</option>
                <option value="flowering">🌸 Flowering</option>
                <option value="flushing">💧 Flushing</option>
                <option value="harvest">🌾 Harvest</option>
              </select>
            </div>
            <div class="gd-field">
              <label id="gd-height-unit-label">Plant Height (in)</label>
              <input type="number" name="height_cm" id="gd-height-input" placeholder="e.g. 18" step="0.25" min="0">
            </div>
          </div>

          <div class="gd-section-title">Environment</div>
          <div class="gd-form-row gd-form-row--4">
            <div class="gd-field">
              <label id="gd-temp-unit-label">Temp (°F)</label>
              <input type="number" name="temp_c" placeholder="77" step="0.5">
            </div>
            <div class="gd-field">
              <label>Humidity (%)</label>
              <input type="number" name="humidity_pct" placeholder="55" min="0" max="100">
            </div>
            <div class="gd-field">
              <label>VPD (kPa)</label>
              <input type="number" name="vpd" placeholder="1.1" step="0.01">
            </div>
            <div class="gd-field">
              <label>Light Hours</label>
              <input type="number" name="light_hours" placeholder="18" min="0" max="24">
            </div>
          </div>

          <div class="gd-section-title">Water & Nutrients</div>
          <div class="gd-form-row gd-form-row--4">
            <div class="gd-field">
              <label>pH (water in)</label>
              <input type="number" name="ph_water" placeholder="6.2" step="0.1" min="0" max="14">
            </div>
            <div class="gd-field">
              <label>pH (runoff)</label>
              <input type="number" name="ph_runoff" placeholder="6.5" step="0.1" min="0" max="14">
            </div>
            <div class="gd-field">
              <label>EC / PPM</label>
              <input type="number" name="ec_ppm" placeholder="850" min="0">
            </div>
            <div class="gd-field">
              <label>Watering (ml)</label>
              <input type="number" name="watering_ml" placeholder="500" min="0">
            </div>
          </div>

          <div class="gd-field">
            <label>Nutrients fed</label>
            <input type="text" name="nutrients" placeholder="e.g. Grow A+B 2ml/L, CalMag 1ml/L">
          </div>

          <div class="gd-section-title">Observations</div>
          <div class="gd-form-row gd-form-row--2">
            <div class="gd-field">
              <label>Observations & Growth Notes</label>
              <textarea name="observations" rows="4" placeholder="How does she look? Describe growth, colour, smell…"></textarea>
            </div>
            <div class="gd-field">
              <label>Problems / Issues</label>
              <textarea name="problems" rows="4" placeholder="Pests, deficiencies, environmental issues…"></textarea>
            </div>
          </div>

          <div class="gd-field">
            <label>Week Rating</label>
            <div class="gd-star-rating" id="gd-star-rating">
              <span data-val="1">★</span>
              <span data-val="2">★</span>
              <span data-val="3">★</span>
              <span data-val="4">★</span>
              <span data-val="5">★</span>
            </div>
            <input type="hidden" name="rating" id="gd-rating-input" value="">
          </div>

          <div class="gd-field">
            <label>Week Photos</label>
            <div class="gd-image-gallery" id="gd-week-gallery"></div>
            <button type="button" class="gd-btn gd-btn-sm" id="gd-week-upload-btn">+ Add Photo</button>
            <input type="hidden" name="images" id="gd-week-images-json" value="[]">
          </div>

          <div class="gd-field">
            <label>📡 Mars Hydro Sensor Data <span class="gd-label-hint">Import CSV to auto-fill env stats &amp; generate chart</span></label>
            <div class="gd-csv-upload-row">
              <input type="file" id="gd-csv-file-input" accept=".csv" style="display:none">
              <button type="button" class="gd-btn gd-btn-sm gd-btn-sensor" id="gd-csv-upload-btn">📂 Import Mars Hydro CSV</button>
              <span id="gd-csv-status"></span>
            </div>
            <input type="hidden" name="chart_data" id="gd-chart-data-json" value="">
          </div>

          <div class="gd-form-actions">
            <button type="submit" class="gd-btn gd-btn-primary">Save Week</button>
            <button type="button" class="gd-btn gd-btn-danger" id="gd-delete-week-btn">Delete Entry</button>
          </div>
          <div class="gd-form-msg" id="gd-week-msg"></div>
        </form>

      </div>
    </div>
  </div>

  <!-- ===================================================
       MODAL: Confirm Delete
  =================================================== -->
  <div id="gd-modal-confirm" class="gd-modal" style="display:none">
    <div class="gd-modal-overlay"></div>
    <div class="gd-modal-box gd-modal-box--sm">
      <div class="gd-modal-header">
        <h2>Confirm Delete</h2>
        <button class="gd-modal-close" data-close="gd-modal-confirm">&times;</button>
      </div>
      <div class="gd-modal-body">
        <p id="gd-confirm-msg">Are you sure? This cannot be undone.</p>
        <div class="gd-form-actions">
          <button class="gd-btn gd-btn-danger" id="gd-confirm-yes">Yes, Delete</button>
          <button class="gd-btn gd-btn-ghost" data-close="gd-modal-confirm">Cancel</button>
        </div>
      </div>
    </div>
  </div>

  <!-- ===================================================
       LIGHTBOX
  =================================================== -->
  <div id="gd-lightbox" style="display:none">
    <div id="gd-lightbox-overlay"></div>
    <button id="gd-lightbox-prev">&#8249;</button>
    <div id="gd-lightbox-content">
      <img id="gd-lightbox-img" src="" alt="">
      <div id="gd-lightbox-counter"></div>
    </div>
    <button id="gd-lightbox-next">&#8250;</button>
    <button id="gd-lightbox-close">&times;</button>
  </div>

</div><!-- #gd-app -->
