<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<div id="gd-view-app">

  <div class="gd-loading" id="gd-view-loading">Loading diary…</div>

  <div id="gd-view-content" style="display:none">

    <!-- =====================================================
         HERO BANNER
    ===================================================== -->
    <div class="gd-diary-hero" id="gd-diary-hero">
      <div class="gd-diary-hero-overlay">
        <div class="gd-diary-hero-info">
          <div class="gd-hero-breadcrumb">
            <a href="<?php echo esc_url( home_url('/my-grows/') ); ?>">← My Grows</a>
          </div>
          <h1 id="gd-view-title"></h1>
          <p id="gd-view-meta"></p>
          <div class="gd-diary-tags" id="gd-view-tags"></div>
        </div>
      </div>
    </div>

    <!-- =====================================================
         GROW SETUP RECAP CARD
    ===================================================== -->
    <div class="gd-recap-grid" id="gd-recap-grid">
      <!-- JS fills this -->
    </div>

    <!-- =====================================================
         GROW PROGRESS BAR  (weeks logged / 20)
    ===================================================== -->
    <div class="gd-progress-wrap" id="gd-progress-wrap">
      <div class="gd-progress-header">
        <span id="gd-progress-label">Grow Progress</span>
        <span id="gd-progress-count"></span>
      </div>
      <div class="gd-progress-track">
        <div class="gd-progress-fill" id="gd-progress-fill"></div>
      </div>
      <div class="gd-week-pip-row" id="gd-week-pip-row">
        <!-- one pip per week -->
      </div>
    </div>

    <!-- =====================================================
         QUICK STATS SUMMARY  (best/avg across all weeks)
    ===================================================== -->
    <div class="gd-summary-stats" id="gd-summary-stats" style="display:none">
      <h2 class="gd-section-heading">📊 Grow Summary</h2>
      <div class="gd-summary-grid" id="gd-summary-grid">
        <!-- JS fills this -->
      </div>
    </div>

    <!-- =====================================================
         UNIT TOGGLES
    ===================================================== -->
    <div class="gd-view-toggles" id="gd-view-toggles" style="display:none">
      <button type="button" id="gd-view-temp-toggle"   class="gd-btn gd-btn-sm gd-unit-toggle"></button>
      <button type="button" id="gd-view-height-toggle" class="gd-btn gd-btn-sm gd-unit-toggle"></button>
    </div>

    <!-- =====================================================
         WEEKLY TIMELINE
    ===================================================== -->
    <h2 class="gd-section-heading" id="gd-weeks-heading" style="display:none">📅 Week-by-Week Log</h2>
    <div class="gd-timeline" id="gd-timeline"></div>

    <!-- Empty state -->
    <div id="gd-no-weeks" class="gd-notice" style="display:none">
      <p>No weekly entries yet. <a href="<?php echo esc_url( home_url('/my-grows/') ); ?>">Go to your dashboard</a> to start logging.</p>
    </div>

  </div>

  <div id="gd-view-error" class="gd-notice gd-notice--error" style="display:none"></div>

</div><!-- #gd-view-app -->

<!-- =========================================================
     LIGHTBOX (shared)
========================================================= -->
<div id="gd-lightbox" style="display:none">
  <div id="gd-lightbox-overlay"></div>
  <button id="gd-lightbox-prev">&#8249;</button>
  <div id="gd-lightbox-content">
    <img id="gd-lightbox-img" src="" alt="">
    <div id="gd-lightbox-counter"></div>
  </div>
  <button id="gd-lightbox-next">&#8250;</button>
  <button id="gd-lightbox-close">&times;</button>
</div>
